/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.testing.dto.TestPlanItemDto;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestRun;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.beans.BeanUtils;

@Entity
public class TestPlanItem
extends BaseEntity {
    private static final long serialVersionUID = -5125452752727206777L;
    private Long testPlanId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_case_id")
    private TestCase testCase;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="latest_run_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private TestRun latestRun;

    public TestPlanItemDto toDto() {
        return this.toDto(false);
    }

    public TestPlanItemDto toDto(boolean detailed) {
        TestPlanItemDto dto = new TestPlanItemDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.testCase != null) {
            this.testCase.setLatestRun(null);
            dto.setTestCase(this.testCase.toDto());
        }
        if (this.latestRun != null) {
            this.latestRun.setTestCase(null);
            dto.setLatestRun(this.latestRun.toDto());
        }
        return dto;
    }

    public TestPlanItem() {
    }

    public TestPlanItem(Long id) {
        this.id = id;
    }

    public Long getTestPlanId() {
        return this.testPlanId;
    }

    public void setTestPlanId(Long testPlanId) {
        this.testPlanId = testPlanId;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public TestRun getLatestRun() {
        return this.latestRun;
    }

    public void setLatestRun(TestRun latestRun) {
        this.latestRun = latestRun;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestPlanItem{");
        sb.append("id=").append(this.id);
        sb.append(", testPlanId=").append(this.testPlanId);
        sb.append(", testCase=").append(this.testCase);
        sb.append('}');
        return sb.toString();
    }
}

