/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.testing.dto.TestReportDto;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestReport;
import com.shimi.gogoscrum.testing.utils.BugSummaryToStringConverter;
import com.shimi.gogoscrum.testing.utils.CaseSummaryToStringConverter;
import com.shimi.gogoscrum.user.model.User;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.beans.BeanUtils;

@Entity
public class TestReport
extends BaseEntity {
    private static final long serialVersionUID = 1207962867741861845L;
    private Long projectId;
    private String name;
    private String description;
    private Date startDate;
    private Date endDate;
    @ManyToOne
    @JoinColumn(name="owner_id")
    @NotFound(action=NotFoundAction.IGNORE)
    private User owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_plan_id")
    private TestPlan testPlan;
    @Convert(converter=CaseSummaryToStringConverter.class)
    private CaseSummary caseSummary;
    @Convert(converter=BugSummaryToStringConverter.class)
    private BugSummary bugSummary;

    public TestReportDto toDto() {
        return this.toDto(false);
    }

    public TestReportDto toDto(boolean detailed) {
        TestReportDto dto = new TestReportDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto());
        }
        if (this.owner != null) {
            dto.setOwner(this.owner.toDto().normalize());
        }
        if (this.testPlan != null) {
            dto.setTestPlan(this.testPlan.toDto().normalize());
        }
        return dto;
    }

    public TestReport() {
    }

    public TestReport(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CaseSummary getCaseSummary() {
        return this.caseSummary;
    }

    public void setCaseSummary(CaseSummary caseSummary) {
        this.caseSummary = caseSummary;
    }

    public BugSummary getBugSummary() {
        return this.bugSummary;
    }

    public void setBugSummary(BugSummary bugSummary) {
        this.bugSummary = bugSummary;
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestReport{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", projectId=").append(this.projectId);
        sb.append('}');
        return sb.toString();
    }
}

