/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.testing.dto.TestRunDto;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.model.TestStepResult;
import com.shimi.gogoscrum.testing.utils.ListOfStepResultToStringConverter;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@Entity
public class TestRun
extends BaseEntity {
    private static final long serialVersionUID = 6409453185785371608L;
    private Long projectId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_case_id")
    private TestCase testCase;
    private Long testCaseDetailsId;
    private Integer testCaseVersion;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_plan_id")
    private TestPlan testPlan;
    @Convert(converter=ListOfStepResultToStringConverter.class)
    private List<TestStepResult> stepResults = new ArrayList();
    @Enumerated(value=EnumType.STRING)
    private TestRunStatus status;
    private String result;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="test_run_file", joinColumns={@JoinColumn(name="test_run_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id")})
    private List<File> files = new ArrayList();

    public TestRunDto toDto() {
        return this.toDto(false);
    }

    public TestRunDto toDto(boolean detailed) {
        TestRunDto dto = new TestRunDto();
        BeanUtils.copyProperties((Object)this, (Object)dto);
        if (this.createdBy != null) {
            dto.setCreatedBy(this.createdBy.toDto());
        }
        if (this.testCase != null) {
            this.testCase.setLatestRun(null);
            dto.setTestCase(this.testCase.toDto());
            dto.setTestCaseId(this.testCase.getId());
        }
        if (this.testPlan != null) {
            dto.setTestPlan(this.testPlan.toDto());
            dto.setTestPlanId(this.testPlan.getId());
        }
        if (detailed && !CollectionUtils.isEmpty((Collection)this.files)) {
            List fileDtos = this.files.stream().map(File::toDto).collect(Collectors.toList());
            dto.setFiles(fileDtos);
        }
        return dto;
    }

    public TestRun() {
    }

    public TestRun(Long id) {
        this.id = id;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public Long getTestCaseDetailsId() {
        return this.testCaseDetailsId;
    }

    public void setTestCaseDetailsId(Long testCaseDetailsId) {
        this.testCaseDetailsId = testCaseDetailsId;
    }

    public Integer getTestCaseVersion() {
        return this.testCaseVersion;
    }

    public void setTestCaseVersion(Integer testCaseVersion) {
        this.testCaseVersion = testCaseVersion;
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public List<TestStepResult> getStepResults() {
        return this.stepResults;
    }

    public void setStepResults(List<TestStepResult> stepResults) {
        this.stepResults = stepResults;
    }

    public TestRunStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestRunStatus status) {
        this.status = status;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestRun{");
        sb.append("projectId=").append(this.projectId);
        sb.append(", testCase=").append(this.testCase);
        sb.append(", testCaseDetailsId=").append(this.testCaseDetailsId);
        sb.append(", version=").append(this.testCaseVersion);
        sb.append(", testPlan=").append(this.testPlan);
        sb.append(", stepResults=").append(this.stepResults);
        sb.append(", status=").append(this.status);
        sb.append(", result='").append(this.result).append('\'');
        sb.append(", id=").append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

