/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.repository;

import com.shimi.gogoscrum.common.model.Priority;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.model.TestType;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;

public class TestCaseSpecs {
    private TestCaseSpecs() {
    }

    public static Specification<TestCase> nameLike(String keyword) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)testCase.get("details").get("name"), "%" + keyword + "%");
    }

    public static Specification<TestCase> codeEquals(Long code) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testCase.get("code"), (Object)code);
    }

    public static Specification<TestCase> projectIdEquals(Long projectId) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testCase.get("projectId"), (Object)projectId);
    }

    public static Specification<TestCase> componentIdIn(List<Long> componentIds) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testCase.get("details").get("componentId")).value((Object)componentIds);
    }

    public static Specification<TestCase> typeIn(List<TestType> types) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testCase.get("details").get("type")).value((Object)types);
    }

    public static Specification<TestCase> priorityIn(List<Priority> priorities) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testCase.get("details").get("priority")).value((Object)priorities);
    }

    public static Specification<TestCase> runStatusIn(List<TestRun.TestRunStatus> runStatuses) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testCase.get("latestRun").get("status")).value((Object)runStatuses);
    }

    public static Specification<TestCase> ownerIdIn(List<Long> ownerIds) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testCase.get("details").get("owner").get("id")).value((Object)ownerIds);
    }

    public static Specification<TestCase> creatorIdIn(List<Long> creatorIds) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testCase.get("createdBy").get("id")).value((Object)creatorIds);
    }

    public static Specification<TestCase> deletedEquals(Boolean deleted) {
        return (Specification & Serializable)(testCase, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testCase.get("deleted"), (Object)deleted);
    }
}

