/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.repository;

import com.shimi.gogoscrum.testing.model.TestPlanItem;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import org.springframework.data.jpa.domain.Specification;

public class TestPlanItemSpecs {
    private TestPlanItemSpecs() {
    }

    public static Specification<TestPlanItem> planIdEquals(Long planId) {
        return (Specification & Serializable)(planItem, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)planItem.get("testPlanId"), (Object)planId);
    }

    public static Specification<TestPlanItem> caseDeletedEquals(Boolean deleted) {
        return (Specification & Serializable)(planItem, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)planItem.get("testCase").get("deleted"), (Object)deleted);
    }

    public static Specification<TestPlanItem> caseNameLike(String keyword) {
        return (Specification & Serializable)(planItem, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)planItem.get("testCase").get("details").get("name"), "%" + keyword + "%");
    }

    public static Specification<TestPlanItem> caseCodeEquals(Long code) {
        return (Specification & Serializable)(planItem, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)planItem.get("testCase").get("code"), (Object)code);
    }
}

