/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.repository;

import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestType;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;

public class TestPlanSpecs {
    private TestPlanSpecs() {
    }

    public static Specification<TestPlan> nameLike(String keyword) {
        return (Specification & Serializable)(testPlan, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)testPlan.get("name"), "%" + keyword + "%");
    }

    public static Specification<TestPlan> projectIdEquals(Long projectId) {
        return (Specification & Serializable)(testPlan, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testPlan.get("projectId"), (Object)projectId);
    }

    public static Specification<TestPlan> deletedEquals(Boolean deleted) {
        return (Specification & Serializable)(testPlan, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testPlan.get("deleted"), (Object)deleted);
    }

    public static Specification<TestPlan> typeIn(List<TestType> types) {
        return (Specification & Serializable)(testPlan, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testPlan.get("type")).value((Object)types);
    }

    public static Specification<TestPlan> ownerIdIn(List<Long> ownerIds) {
        return (Specification & Serializable)(testPlan, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testPlan.get("owner").get("id")).value((Object)ownerIds);
    }

    public static Specification<TestPlan> creatorIdIn(List<Long> creatorIds) {
        return (Specification & Serializable)(testPlan, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testPlan.get("createdBy").get("id")).value((Object)creatorIds);
    }
}

