/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.repository;

import com.shimi.gogoscrum.testing.model.TestReport;
import com.shimi.gsf.core.repository.GeneralRepository;
import java.util.List;
import org.springframework.data.jpa.repository.Query;

public interface TestReportRepository
extends GeneralRepository<TestReport> {
    @Query(value="SELECT i.testCase.id FROM TestPlanItem i WHERE i.testPlanId = :planId")
    public List<Long> findCaseIds(Long var1);

    @Query(value="SELECT d.componentId, COUNT(d) FROM TestCaseDetails d INNER JOIN TestPlanItem i on d.testCaseId = i.testCase.id INNER JOIN TestCase c ON c.details.id = d.id WHERE i.testPlanId = :planId GROUP BY d.componentId ORDER BY CASE WHEN d.componentId IS NULL THEN 1 ELSE 0 END, d.componentId")
    public List<Object[]> countCaseByComponent(Long var1);

    @Query(value="SELECT d.type, COUNT(d) FROM TestCaseDetails d INNER JOIN TestPlanItem i on d.testCaseId = i.testCase.id INNER JOIN TestCase c ON c.details.id = d.id WHERE i.testPlanId = :planId GROUP BY d.type ORDER BY CASE WHEN d.type IS NULL THEN 1 ELSE 0 END")
    public List<Object[]> countCaseByType(Long var1);

    @Query(value="SELECT r.createdBy.id, COUNT(c) FROM TestRun r INNER JOIN TestCase c on c.latestRun.id = r.id INNER JOIN TestPlanItem i on c.id = i.testCase.id WHERE i.testPlanId = :planId AND r.testPlan.id = i.testPlanId GROUP BY r.createdBy.id")
    public List<Object[]> countCaseByExecutor(Long var1);

    @Query(value="SELECT i.id FROM Issue i WHERE i.testPlan.id = :planId AND i.type = 'BUG'")
    public List<Long> findBugIds(Long var1);

    @Query(value="SELECT i.priority, COUNT(i) FROM Issue i WHERE i.testPlan.id = :planId GROUP BY i.priority ORDER BY i.priority DESC")
    public List<Object[]> countBugByPriority(Long var1);

    @Query(value="SELECT i.issueGroup.label, COUNT(i) FROM Issue i WHERE i.testPlan.id = :planId GROUP BY i.issueGroup.label, i.issueGroup.seq ORDER BY i.issueGroup.seq")
    public List<Object[]> countBugByStatus(Long var1);

    @Query(value="SELECT i.createdBy.id, COUNT(i) FROM Issue i WHERE i.testPlan.id = :planId GROUP BY i.createdBy.id")
    public List<Object[]> countBugByCreator(Long var1);

    @Query(value="SELECT i.owner.id, COUNT(i) FROM Issue i WHERE i.testPlan.id = :planId GROUP BY i.owner.id")
    public List<Object[]> countBugByAssignee(Long var1);

    @Query(value="SELECT i.component.id, COUNT(i) FROM Issue i WHERE i.testPlan.id = :planId GROUP BY i.component.id")
    public List<Object[]> countBugByComponent(Long var1);
}

