/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.repository;

import com.shimi.gogoscrum.testing.model.TestReport;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;

public class TestReportSpecs {
    private TestReportSpecs() {
    }

    public static Specification<TestReport> nameLike(String keyword) {
        return (Specification & Serializable)(testReport, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)testReport.get("name"), "%" + keyword + "%");
    }

    public static Specification<TestReport> projectIdEquals(Long projectId) {
        return (Specification & Serializable)(testReport, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testReport.get("projectId"), (Object)projectId);
    }

    public static Specification<TestReport> planIdEquals(Long testPlanId) {
        return (Specification & Serializable)(testReport, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testReport.get("testPlan").get("id"), (Object)testPlanId);
    }

    public static Specification<TestReport> planIdIn(List<Long> planIds) {
        return (Specification & Serializable)(testReport, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testReport.get("testPlan").get("id")).value((Object)planIds);
    }

    public static Specification<TestReport> creatorIdIn(List<Long> creatorIds) {
        return (Specification & Serializable)(testReport, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testReport.get("createdBy").get("id")).value((Object)creatorIds);
    }
}

