/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.repository;

import com.shimi.gogoscrum.testing.model.TestRun;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;

public class TestRunSpecs {
    private TestRunSpecs() {
    }

    public static Specification<TestRun> projectIdEquals(Long projectId) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("projectId"), (Object)projectId);
    }

    public static Specification<TestRun> caseDeletedEquals(Boolean deleted) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("testCase").get("deleted"), (Object)deleted);
    }

    public static Specification<TestRun> caseNameLike(String keyword) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.like((Expression)testRun.get("testCase").get("details").get("name"), "%" + keyword + "%");
    }

    public static Specification<TestRun> caseCodeEquals(Long code) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("testCase").get("code"), (Object)code);
    }

    public static Specification<TestRun> caseIdEquals(Long caseId) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("testCase").get("id"), (Object)caseId);
    }

    public static Specification<TestRun> caseDetailsIdEquals(Long testCaseDetailsId) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("testCaseDetailsId"), (Object)testCaseDetailsId);
    }

    public static Specification<TestRun> caseVersionEquals(Integer version) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("version"), (Object)version);
    }

    public static Specification<TestRun> statusEquals(TestRun.TestRunStatus status) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("status"), (Object)status);
    }

    public static Specification<TestRun> statusIn(List<TestRun.TestRunStatus> statuses) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testRun.get("status")).value((Object)statuses);
    }

    public static Specification<TestRun> planIdEquals(Long testPlanId) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)testRun.get("testPlan").get("id"), (Object)testPlanId);
    }

    public static Specification<TestRun> planIdIn(List<Long> planIds) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testRun.get("testPlan").get("id")).value((Object)planIds);
    }

    public static Specification<TestRun> creatorIdIn(List<Long> creatorIds) {
        return (Specification & Serializable)(testRun, criteriaQuery, criteriaBuilder) -> criteriaBuilder.in((Expression)testRun.get("createdBy").get("id")).value((Object)creatorIds);
    }
}

