/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestCaseDetails;
import com.shimi.gogoscrum.testing.model.TestCaseFilter;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.repository.TestCaseDetailsRepository;
import com.shimi.gogoscrum.testing.repository.TestCaseRepository;
import com.shimi.gogoscrum.testing.repository.TestCaseSpecs;
import com.shimi.gogoscrum.testing.repository.TestRunRepository;
import com.shimi.gogoscrum.testing.service.TestCaseService;
import com.shimi.gsf.core.event.EntityChangeEvent;
import com.shimi.gsf.core.exception.BadRequestException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.User;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TestCaseServiceImpl
extends BaseServiceImpl<TestCase, TestCaseFilter>
implements TestCaseService {
    private static final Logger log = LoggerFactory.getLogger(TestCaseServiceImpl.class);
    @Autowired
    private TestCaseRepository repository;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TestCaseDetailsRepository detailsRepository;
    @Autowired
    private TestRunRepository testRunRepository;

    protected TestCaseRepository getRepository() {
        return this.repository;
    }

    public TestCase create(TestCase testCase) {
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testCase.getProjectId())), (com.shimi.gogoscrum.user.model.User)currentUser);
        this.validateTestCase(testCase);
        TestCaseDetails details = testCase.getDetails();
        testCase.setCode(Long.valueOf(this.generateNextCaseCode(testCase.getProjectId())));
        testCase.setDetails(null);
        TestCase createdTestCase = (TestCase)super.create((Entity)testCase);
        details.setId(null);
        details.setTestCaseId(createdTestCase.getId());
        details.setVersion(Integer.valueOf(1));
        details.setAllTraceInfo((User)currentUser);
        TestCaseDetails savedDetails = (TestCaseDetails)this.detailsRepository.save((Object)details);
        if (log.isDebugEnabled()) {
            log.debug("Test case details created: {}", (Object)savedDetails);
        }
        createdTestCase.setDetails(savedDetails);
        createdTestCase.setLatestVersion(savedDetails.getVersion());
        this.repository.save((Object)createdTestCase);
        return createdTestCase;
    }

    public TestCase update(Long id, TestCase testCase) {
        this.validateTestCase(testCase);
        TestCase existingCase = (TestCase)this.get(id);
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(existingCase.getProjectId())), (com.shimi.gogoscrum.user.model.User)currentUser);
        if (existingCase.isDeleted()) {
            throw new BadRequestException("Cannot update a deleted test case");
        }
        TestCaseDetails details = testCase.getDetails();
        details.setId(null);
        details.setTestCaseId(id);
        details.setVersion(Integer.valueOf(this.generateNextVersion(id.longValue())));
        details.setAllTraceInfo((User)currentUser);
        TestCaseDetails savedDetails = (TestCaseDetails)this.detailsRepository.save((Object)details);
        existingCase.setDetails(savedDetails);
        existingCase.setLatestVersion(savedDetails.getVersion());
        existingCase.setFiles(testCase.getFiles());
        existingCase.setUpdateTraceInfo((User)currentUser);
        TestCase updatedCase = (TestCase)this.repository.save((Object)existingCase);
        log.info("Created new version of details for test case {}: {}", (Object)id, (Object)savedDetails);
        return updatedCase;
    }

    public void delete(Long id) {
        TestCase testCase = (TestCase)this.get(id);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testCase.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        testCase.setDeleted(true);
        testCase.setUpdateTraceInfo((User)this.getCurrentUser());
        this.repository.save((Object)testCase);
        log.info("Test case has execution results, soft deleted: {}", (Object)testCase);
    }

    public TestCaseDetails getDetails(Long testCaseId, Integer version) {
        TestCase testCase = (TestCase)this.get(testCaseId);
        ProjectMemberUtils.checkMember((Project)((Project)this.projectService.get(testCase.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        TestCaseDetails details = this.detailsRepository.findByTestCaseIdAndVersion(testCaseId, version);
        if (details == null) {
            throw new BadRequestException("Test case details version not found: " + version);
        }
        return details;
    }

    private long generateNextCaseCode(Long projectId) {
        long previousCode = Objects.requireNonNullElse(this.repository.getMaxCode(projectId.longValue()), 0L);
        return previousCode + 1L;
    }

    private int generateNextVersion(long caseId) {
        Integer previousVersion = Objects.requireNonNullElse(this.detailsRepository.getMaxVersion(caseId), 0);
        return previousVersion + 1;
    }

    private void validateTestCase(TestCase testCase) {
        if (testCase.getProjectId() == null) {
            throw new BadRequestException("Project ID must be provided for the test case");
        }
        if (testCase.getDetails() == null) {
            throw new BadRequestException("Test case details must be provided");
        }
        if (!StringUtils.hasText((String)testCase.getDetails().getName())) {
            throw new BadRequestException("Test case name cannot be empty");
        }
    }

    public TestCase clone(long testCaseId) {
        TestCase originalTestCase = (TestCase)this.get(Long.valueOf(testCaseId));
        TestCaseDetails originalDetails = originalTestCase.getDetails();
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(originalTestCase.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        TestCase clonedCase = new TestCase();
        TestCaseDetails clonedDetails = new TestCaseDetails();
        BeanUtils.copyProperties((Object)originalTestCase, (Object)clonedCase, (String[])new String[]{"id", "details", "files", "latestRun"});
        BeanUtils.copyProperties((Object)originalDetails, (Object)clonedDetails);
        clonedDetails.setName("Copy of " + originalDetails.getName());
        clonedCase.setDetails(clonedDetails);
        return this.create(clonedCase);
    }

    @EventListener
    public void onExecutionRecordChanged(EntityChangeEvent event) {
        TestRun run;
        Entity entity = Objects.requireNonNullElse(event.getPreviousEntity(), event.getUpdatedEntity());
        if (entity instanceof TestRun && (run = (TestRun)entity).getTestCase() != null) {
            this.refreshLatestRun(run.getTestCase().getId());
        }
    }

    private void refreshLatestRun(Long caseId) {
        TestCase testCase = (TestCase)this.get(caseId);
        if (testCase == null) {
            log.warn("Test case with ID {} not found for refreshing latest run", (Object)caseId);
            return;
        }
        TestRun latestRun = this.testRunRepository.findTopByTestCaseIdOrderByIdDesc(caseId);
        if (latestRun != null) {
            testCase.setLatestRun(latestRun);
            this.repository.save((Object)testCase);
            log.info("Updated latest execution record for test case {}: {}", (Object)caseId, (Object)latestRun);
        } else {
            testCase.setLatestRun(null);
            this.repository.save((Object)testCase);
            log.info("No execution record found for test case {}, set to null", (Object)caseId);
        }
    }

    protected Specification<TestCase> toSpec(TestCaseFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() == null) {
            throw new BadRequestException("Project ID is required to query test cases");
        }
        querySpec = TestCaseSpecs.projectIdEquals((Long)filter.getProjectId());
        if (!CollectionUtils.isEmpty((Collection)filter.getComponentIds())) {
            Specification componentIdIn = TestCaseSpecs.componentIdIn((List)filter.getComponentIds());
            querySpec = querySpec.and(componentIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getTypes())) {
            Specification typeIn = TestCaseSpecs.typeIn((List)filter.getTypes());
            querySpec = querySpec.and(typeIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getPriorities())) {
            Specification priorityIn = TestCaseSpecs.priorityIn((List)filter.getPriorities());
            querySpec = querySpec.and(priorityIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getRunStatuses())) {
            Specification runStatusIn = TestCaseSpecs.runStatusIn((List)filter.getRunStatuses());
            querySpec = querySpec.and(runStatusIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getOwners())) {
            Specification ownerIdIn = TestCaseSpecs.ownerIdIn((List)filter.getOwners());
            querySpec = querySpec.and(ownerIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getCreators())) {
            Specification creatorIdIn = TestCaseSpecs.creatorIdIn((List)filter.getCreators());
            querySpec = querySpec.and(creatorIdIn);
        }
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification codeOrNameLike = TestCaseSpecs.nameLike((String)keyword);
            try {
                Long code = Long.valueOf(keyword);
                codeOrNameLike = TestCaseSpecs.codeEquals((Long)code).or(codeOrNameLike);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            querySpec = querySpec.and(codeOrNameLike);
        }
        if (filter.getDeleted() != null) {
            Specification deletedEquals = TestCaseSpecs.deletedEquals((Boolean)filter.getDeleted());
            querySpec = querySpec.and(deletedEquals);
        }
        return querySpec;
    }
}

