/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.testing.model.TestCase;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestPlanItem;
import com.shimi.gogoscrum.testing.model.TestPlanItemFilter;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.repository.TestPlanItemRepository;
import com.shimi.gogoscrum.testing.repository.TestPlanItemSpecs;
import com.shimi.gogoscrum.testing.repository.TestRunRepository;
import com.shimi.gogoscrum.testing.service.TestPlanItemService;
import com.shimi.gogoscrum.testing.service.TestPlanService;
import com.shimi.gsf.core.event.EntityChangeEvent;
import com.shimi.gsf.core.exception.BadRequestException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.User;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TestPlanItemServiceImpl
extends BaseServiceImpl<TestPlanItem, TestPlanItemFilter>
implements TestPlanItemService {
    private static final Logger log = LoggerFactory.getLogger(TestPlanItemServiceImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TestPlanService planService;
    @Autowired
    private TestPlanItemRepository repository;
    @Autowired
    private TestRunRepository testRunRepository;

    public List<Long> findTestCaseIds(Long testPlanId) {
        return this.repository.findCaseIds(testPlanId);
    }

    public List<TestPlanItem> linkAll(Long planId, List<Long> caseIds) {
        TestPlan plan = (TestPlan)this.planService.get(planId);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(plan.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        List<TestPlanItem> items = caseIds.stream().map(caseId -> {
            TestPlanItem item = new TestPlanItem();
            item.setTestPlanId(planId);
            item.setTestCase(new TestCase(caseId));
            item.setAllTraceInfo((User)this.getCurrentUser());
            return item;
        }).toList();
        this.repository.saveAll(items);
        log.info("Linked {} test cases to test plan {}: {}", new Object[]{caseIds.size(), planId, caseIds});
        this.planService.refreshSummary(planId.longValue());
        return items;
    }

    protected void afterDelete(TestPlanItem item) {
        this.planService.refreshSummary(item.getTestPlanId().longValue());
    }

    @EventListener
    public void onExecutionRecordChanged(EntityChangeEvent event) {
        TestRun run;
        Entity entity = Objects.requireNonNullElse(event.getPreviousEntity(), event.getUpdatedEntity());
        if (entity instanceof TestRun && (run = (TestRun)entity).getTestCase() != null && run.getTestPlan() != null) {
            this.refreshItemLatestRun(run.getTestCase().getId(), run.getTestPlan().getId());
        }
    }

    private void refreshItemLatestRun(Long caseId, Long planId) {
        TestPlanItem item = this.repository.findByTestCaseIdAndTestPlanId(caseId, planId);
        TestRun latestRun = this.testRunRepository.findTopByTestCaseIdAndTestPlanIdOrderByIdDesc(caseId, planId);
        if (latestRun != null) {
            item.setLatestRun(latestRun);
            this.repository.save((Object)item);
            log.info("Updated latest execution record for test plan item {}: {}", (Object)item.getId(), (Object)latestRun);
        } else {
            item.setLatestRun(null);
            this.repository.save((Object)item);
            log.info("No execution record found for test plan item {}, set to null", (Object)item.getId());
        }
        this.planService.refreshSummary(planId.longValue());
    }

    protected Specification<TestPlanItem> toSpec(TestPlanItemFilter filter) {
        Specification querySpec = TestPlanItemSpecs.caseDeletedEquals((Boolean)Boolean.FALSE);
        if (filter.getTestPlanId() == null) {
            throw new BadRequestException("Test plan ID is required for filtering test plan items.");
        }
        Specification planIdEquals = TestPlanItemSpecs.planIdEquals((Long)filter.getTestPlanId());
        querySpec = querySpec.and(planIdEquals);
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification codeOrNameLike = TestPlanItemSpecs.caseNameLike((String)keyword);
            try {
                Long code = Long.valueOf(keyword);
                codeOrNameLike = TestPlanItemSpecs.caseCodeEquals((Long)code).or(codeOrNameLike);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            querySpec = querySpec.and(codeOrNameLike);
        }
        return querySpec;
    }

    protected TestPlanItemRepository getRepository() {
        return this.repository;
    }
}

