/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.testing.model.TestPlan;
import com.shimi.gogoscrum.testing.model.TestPlanFilter;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.repository.TestPlanItemRepository;
import com.shimi.gogoscrum.testing.repository.TestPlanRepository;
import com.shimi.gogoscrum.testing.repository.TestPlanSpecs;
import com.shimi.gogoscrum.testing.service.TestPlanItemService;
import com.shimi.gogoscrum.testing.service.TestPlanService;
import com.shimi.gsf.core.exception.BadRequestException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TestPlanServiceImpl
extends BaseServiceImpl<TestPlan, TestPlanFilter>
implements TestPlanService {
    private static final Logger log = LoggerFactory.getLogger(TestPlanServiceImpl.class);
    @Autowired
    private TestPlanRepository repository;
    @Autowired
    private TestPlanItemRepository itemRepository;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TestPlanItemService testPlanItemService;

    public void delete(Long id) {
        TestPlan testPlan = (TestPlan)this.get(id);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testPlan.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        testPlan.setDeleted(true);
        testPlan.setUpdateTraceInfo((User)this.getCurrentUser());
        this.repository.save((Object)testPlan);
        log.info("Soft deleted test plan: {}", (Object)testPlan);
    }

    public TestPlan clone(long testPlanId) {
        TestPlan originalTestPlan = (TestPlan)this.get(Long.valueOf(testPlanId));
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(originalTestPlan.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        TestPlan clonedTestPlan = new TestPlan();
        BeanUtils.copyProperties((Object)originalTestPlan, (Object)clonedTestPlan);
        clonedTestPlan.setCaseCount(Long.valueOf(0L));
        clonedTestPlan.setExecutedCount(Long.valueOf(0L));
        clonedTestPlan.setSuccessCount(Long.valueOf(0L));
        clonedTestPlan.setFailedCount(Long.valueOf(0L));
        clonedTestPlan.setBlockedCount(Long.valueOf(0L));
        clonedTestPlan.setSkippedCount(Long.valueOf(0L));
        clonedTestPlan.setName("Copy of " + originalTestPlan.getName());
        this.create((Entity)clonedTestPlan);
        List linkedCaseIds = this.testPlanItemService.findTestCaseIds(Long.valueOf(testPlanId));
        if (!CollectionUtils.isEmpty((Collection)linkedCaseIds)) {
            this.testPlanItemService.linkAll(clonedTestPlan.getId(), linkedCaseIds);
        }
        log.info("Linked {} test cases to cloned test plan: {}", (Object)linkedCaseIds.size(), (Object)clonedTestPlan.getId());
        return clonedTestPlan;
    }

    public void refreshSummary(long testPlanId) {
        List rawResults = this.itemRepository.countByLatestRunStatus(Long.valueOf(testPlanId));
        Map<TestRun.TestRunStatus, Long> statusMap = rawResults.stream().collect(Collectors.toMap(arr -> (TestRun.TestRunStatus)arr[0], arr -> (Long)arr[1]));
        TestPlan testPlan = (TestPlan)this.get(Long.valueOf(testPlanId));
        testPlan.setCaseCount(this.itemRepository.countByTestPlanId(Long.valueOf(testPlanId)));
        testPlan.setSuccessCount(statusMap.getOrDefault(TestRun.TestRunStatus.SUCCESS, 0L));
        testPlan.setFailedCount(statusMap.getOrDefault(TestRun.TestRunStatus.FAILED, 0L));
        testPlan.setBlockedCount(statusMap.getOrDefault(TestRun.TestRunStatus.BLOCKED, 0L));
        testPlan.setSkippedCount(statusMap.getOrDefault(TestRun.TestRunStatus.SKIPPED, 0L));
        testPlan.setExecutedCount(Long.valueOf(testPlan.getSuccessCount() + testPlan.getFailedCount() + testPlan.getBlockedCount() + testPlan.getSkippedCount()));
        this.repository.save((Object)testPlan);
        log.info("Refreshed test plan statistics: {}", (Object)testPlan);
    }

    protected void beforeCreate(TestPlan testPlan) {
        this.validateTestPlan(testPlan);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testPlan.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
    }

    protected void beforeUpdate(Long id, TestPlan oldTestPlan, TestPlan newTestPlan) {
        this.validateTestPlan(newTestPlan);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(newTestPlan.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
        if (oldTestPlan.isDeleted()) {
            throw new BadRequestException("Cannot update a deleted test plan");
        }
    }

    protected void beforeDelete(TestPlan testPlan) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testPlan.getProjectId())), (com.shimi.gogoscrum.user.model.User)this.getCurrentUser());
    }

    private void validateTestPlan(TestPlan testPlan) {
        if (testPlan.getProjectId() == null) {
            throw new BadRequestException("Project ID must be provided for the test run");
        }
        if (testPlan.getName() == null || testPlan.getName().isEmpty()) {
            throw new BadRequestException("Test plan name must be provided");
        }
    }

    protected Specification<TestPlan> toSpec(TestPlanFilter filter) {
        Specification querySpec = null;
        if (filter.getProjectId() == null) {
            throw new BadRequestException("Project ID is required to query test plans");
        }
        querySpec = TestPlanSpecs.projectIdEquals((Long)filter.getProjectId());
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification nameLike = TestPlanSpecs.nameLike((String)keyword);
            querySpec = querySpec.and(nameLike);
        }
        if (filter.getDeleted() != null) {
            Specification deletedEquals = TestPlanSpecs.deletedEquals((Boolean)filter.getDeleted());
            querySpec = querySpec.and(deletedEquals);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getTypes())) {
            Specification typeIn = TestPlanSpecs.typeIn((List)filter.getTypes());
            querySpec = querySpec.and(typeIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getOwners())) {
            Specification ownerIdIn = TestPlanSpecs.ownerIdIn((List)filter.getOwners());
            querySpec = querySpec.and(ownerIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getCreators())) {
            Specification creatorIdIn = TestPlanSpecs.creatorIdIn((List)filter.getCreators());
            querySpec = querySpec.and(creatorIdIn);
        }
        return querySpec;
    }

    protected TestPlanRepository getRepository() {
        return this.repository;
    }
}

