/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.testing.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.project.model.Project;
import com.shimi.gogoscrum.project.service.ProjectService;
import com.shimi.gogoscrum.project.utils.ProjectMemberUtils;
import com.shimi.gogoscrum.testing.model.TestRun;
import com.shimi.gogoscrum.testing.model.TestRunFilter;
import com.shimi.gogoscrum.testing.repository.TestRunRepository;
import com.shimi.gogoscrum.testing.repository.TestRunSpecs;
import com.shimi.gogoscrum.testing.service.TestRunService;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gsf.core.exception.BadRequestException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TestRunServiceImpl
extends BaseServiceImpl<TestRun, TestRunFilter>
implements TestRunService {
    private static final Logger log = LoggerFactory.getLogger(TestRunServiceImpl.class);
    @Autowired
    private TestRunRepository repository;
    @Autowired
    private ProjectService projectService;

    protected void beforeCreate(TestRun testRun) {
        this.validateTestRun(testRun);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testRun.getProjectId())), (User)this.getCurrentUser());
    }

    protected void beforeUpdate(Long id, TestRun oldTestRun, TestRun newTestRun) {
        this.validateTestRun(newTestRun);
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(newTestRun.getProjectId())), (User)this.getCurrentUser());
    }

    protected void beforeDelete(TestRun testRun) {
        ProjectMemberUtils.checkDeveloper((Project)((Project)this.projectService.get(testRun.getProjectId())), (User)this.getCurrentUser());
    }

    private void validateTestRun(TestRun testRun) {
        if (testRun.getProjectId() == null) {
            throw new BadRequestException("Project ID must be provided for the test run");
        }
        if (testRun.getTestCase() == null || testRun.getTestCaseDetailsId() == null || testRun.getTestCaseVersion() == null) {
            throw new BadRequestException("Test Case, Details ID and version must be all provided for the test run");
        }
        if (testRun.getStatus() == null) {
            throw new BadRequestException("Test run status must be provided");
        }
    }

    protected Specification<TestRun> toSpec(TestRunFilter filter) {
        Specification querySpec = TestRunSpecs.caseDeletedEquals((Boolean)Boolean.FALSE);
        if (filter.getProjectId() == null) {
            throw new BadRequestException("Project ID is required to query test runs");
        }
        querySpec = querySpec.and(TestRunSpecs.projectIdEquals((Long)filter.getProjectId()));
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification nameLikeOrCodeEquals = TestRunSpecs.caseNameLike((String)keyword);
            try {
                Long code = Long.valueOf(keyword);
                nameLikeOrCodeEquals = TestRunSpecs.caseCodeEquals((Long)code).or(nameLikeOrCodeEquals);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            querySpec = querySpec.and(nameLikeOrCodeEquals);
        }
        if (filter.getCaseId() != null) {
            Specification testCaseIdEquals = TestRunSpecs.caseIdEquals((Long)filter.getCaseId());
            querySpec = querySpec.and(testCaseIdEquals);
        }
        if (filter.getCaseDetailsId() != null) {
            Specification testCaseDetailsIdEquals = TestRunSpecs.caseDetailsIdEquals((Long)filter.getCaseDetailsId());
            querySpec = querySpec.and(testCaseDetailsIdEquals);
        }
        if (filter.getVersion() != null) {
            Specification versionEquals = TestRunSpecs.caseVersionEquals((Integer)filter.getVersion());
            querySpec = querySpec.and(versionEquals);
        }
        if (filter.getStatus() != null) {
            Specification statusEquals = TestRunSpecs.statusEquals((TestRun.TestRunStatus)filter.getStatus());
            querySpec = querySpec.and(statusEquals);
        } else if (!CollectionUtils.isEmpty((Collection)filter.getStatuses())) {
            Specification statusIn = TestRunSpecs.statusIn((List)filter.getStatuses());
            querySpec = querySpec.and(statusIn);
        }
        if (filter.getPlanId() != null) {
            Specification testPlanIdEquals = TestRunSpecs.planIdEquals((Long)filter.getPlanId());
            querySpec = querySpec.and(testPlanIdEquals);
        } else if (!CollectionUtils.isEmpty((Collection)filter.getPlanIds())) {
            Specification planIdIn = TestRunSpecs.planIdIn((List)filter.getPlanIds());
            querySpec = querySpec.and(planIdIn);
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getCreators())) {
            Specification creatorIdIn = TestRunSpecs.creatorIdIn((List)filter.getCreators());
            querySpec = querySpec.and(creatorIdIn);
        }
        return querySpec;
    }

    protected TestRunRepository getRepository() {
        return this.repository;
    }
}

