/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.user.authentication;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.shimi.gogoscrum.common.util.IpUtil;
import com.shimi.gogoscrum.user.dto.UserDto;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gogoscrum.user.service.UserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationHandler
implements AuthenticationSuccessHandler,
AuthenticationFailureHandler,
LogoutSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationHandler.class);
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String CHARACTER = "UTF-8";
    private static final String MESSAGE_KEY = "message";
    @Autowired
    private UserService userService;

    @Transactional
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        User principal = (User)authentication.getPrincipal();
        User user = (User)this.userService.get(principal.getId());
        try {
            String ipAddr = IpUtil.getIpAddr((HttpServletRequest)request);
            user.setLastLoginIp(ipAddr);
            this.userService.updateLastLoginInfo(user);
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new SimpleModule().addSerializer(Long.class, (JsonSerializer)new ToStringSerializer()));
            HashMap<String, UserDto> map = new HashMap<String, UserDto>();
            map.put("user", user.toDto());
            response.setContentType(CONTENT_TYPE);
            response.setCharacterEncoding(CHARACTER);
            response.getWriter().append(mapper.writeValueAsString(map));
        }
        catch (IllegalArgumentException e) {
            response.setCharacterEncoding(CHARACTER);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "badCredential");
            map.put("status", "401.1");
            map.put(MESSAGE_KEY, e.getMessage());
            ObjectMapper mapper = new ObjectMapper();
            response.setContentType(CONTENT_TYPE);
            response.setCharacterEncoding(CHARACTER);
            response.getWriter().append(mapper.writeValueAsString(map));
            response.setStatus(200);
        }
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        log.trace("Authentication Failed:", (Throwable)exception);
        response.setCharacterEncoding(CHARACTER);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "badCredential");
        map.put("status", "401.1");
        map.put(MESSAGE_KEY, exception.getMessage());
        ObjectMapper mapper = new ObjectMapper();
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(CHARACTER);
        response.getWriter().append(mapper.writeValueAsString(map));
        response.setStatus(200);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MESSAGE_KEY, "Logout successfully");
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(CHARACTER);
        response.getWriter().append(mapper.writeValueAsString(map));
        response.setStatus(200);
    }
}

