/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.user.controller;

import com.shimi.gogoscrum.common.controller.BaseController;
import com.shimi.gogoscrum.common.util.IpUtil;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.user.dto.UserDto;
import com.shimi.gogoscrum.user.model.Preference;
import com.shimi.gogoscrum.user.model.User;
import com.shimi.gogoscrum.user.model.UserFilter;
import com.shimi.gogoscrum.user.oauth.OauthProvider;
import com.shimi.gogoscrum.user.service.UserService;
import com.shimi.gsf.core.dto.Dto;
import com.shimi.gsf.core.dto.DtoQueryResult;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.Filter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/users"})
@CrossOrigin
@Tag(name="User", description="User management")
@RolesAllowed(value={"ROLE_USER"})
public class UserController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private RememberMeServices rememberMeServices;

    @Operation(summary="Create a new user")
    @PostMapping(value={"/register"})
    @PermitAll
    public UserDto register(@RequestBody UserDto userDto, HttpServletRequest request) {
        userDto.setLastLoginIp(IpUtil.getIpAddr((HttpServletRequest)request));
        User user = userDto.toEntity();
        return ((User)this.userService.create((Entity)user)).toDto();
    }

    @Operation(summary="Search Users")
    @Parameters(value={@Parameter(name="filter", description="The search filer")})
    @GetMapping
    public DtoQueryResult<Dto> search(UserFilter filter) {
        filter.setEnabled(Boolean.TRUE);
        EntityQueryResult queryResult = this.userService.search((Filter)filter);
        return queryResult.toDto();
    }

    @Operation(summary="Search project mates, i.e., users who have joined at least one common project with the current user")
    @Parameters(value={@Parameter(name="key", description="The query keywords, can be username or nickname"), @Parameter(name="page", description="The page number, starting from 1"), @Parameter(name="pageSize", description="The page size")})
    @GetMapping(value={"/mates"})
    public DtoQueryResult<Dto> findProjectMates(UserFilter filter) {
        EntityQueryResult queryResults = this.userService.findProjectMates(filter.getPage(), filter.getPageSize(), filter.getKeyword());
        return queryResults.toDto();
    }

    @Operation(summary="Get a user")
    @Parameters(value={@Parameter(name="id", description="The ID of the user")})
    @GetMapping(value={"/{id}"})
    public UserDto get(@PathVariable Long id) {
        User user = (User)this.userService.get(id);
        return user.toDto();
    }

    @Operation(summary="Update current user's basic info")
    @Parameters(value={@Parameter(name="id", description="The ID of the user")})
    @PutMapping(value={"/my/basics"})
    public UserDto updateBasics(@RequestBody UserDto userDto) {
        User user = userDto.toEntity();
        User savedUser = this.userService.updateUserBasics(this.getCurrentUser().getId(), user);
        return savedUser.toDto();
    }

    @Operation(summary="Update current user's avatar")
    @Parameters(value={@Parameter(name="fileDto", description="Avatar image file")})
    @PutMapping(value={"/my/avatar"})
    public UserDto updateAvatar(@RequestBody FileDto fileDto) {
        User user = this.userService.updateAvatar(this.getCurrentUser().getId(), fileDto.toEntity());
        return user.toDto();
    }

    @Operation(summary="Delete current user's avatar")
    @DeleteMapping(value={"/my/avatar"})
    public void deleteAvatar() {
        this.userService.deleteAvatar(this.getCurrentUser().getId());
    }

    @Operation(summary="Update current user's preference")
    @PutMapping(value={"/my/preference"})
    public UserDto updatePreference(@RequestBody Preference preference) {
        User savedUser = this.userService.updatePreference(this.getCurrentUser().getId(), preference);
        return savedUser.toDto();
    }

    @Operation(summary="Check current user's password")
    @Parameters(value={@Parameter(name="password", description="The password of the user.")})
    @GetMapping(value={"/my/pwd/check"})
    public boolean checkOldPassword(@RequestParam(value="password") String oldPassword) {
        return this.userService.checkPassword(this.getCurrentUser().getId(), oldPassword);
    }

    @Operation(summary="Update current user's password")
    @PutMapping(value={"/my/pwd"})
    public void updatePassword(@RequestBody Map<String, String> params) {
        User user = this.getCurrentUser();
        String oldPassword = params.get("oldPassword");
        String newPassword = params.get("newPassword");
        this.userService.updatePassword(user.getId(), oldPassword, newPassword);
    }

    @Operation(summary="Get the list of configured 3rd-party OAuth providers")
    @GetMapping(value={"/oauth/providers"})
    @PermitAll
    public List<OauthProvider.ProviderConfig> getOauthProviders() {
        return this.userService.getOauthProviders();
    }

    @Operation(summary="Get the login URL for a specific OAuth provider")
    @Parameters(value={@Parameter(name="provider", description="The unique name of the OAuth provider")})
    @GetMapping(value={"/oauth/{provider}/login/url"})
    @PermitAll
    public String getOauthLoginUrl(@PathVariable String provider) {
        return this.userService.getOauthProvider(provider).getLoginUrl();
    }

    @Operation(summary="Login or register with 3rd party OAuth info")
    @PostMapping(value={"/oauth/login"})
    @PermitAll
    public UserDto loginByOauth(@RequestBody OauthProvider.OauthInfo oauthDto, @RequestParam(value="rememberMe") boolean rememberMe, HttpServletRequest request, HttpServletResponse response) {
        User user = this.userService.retrieveUser(oauthDto);
        user.setLastLoginIp(IpUtil.getIpAddr((HttpServletRequest)request));
        if (user.getId() != null) {
            Authentication auth = this.authenticateUser(user, request, response);
            if (rememberMe) {
                this.rememberMeServices.loginSuccess(request, response, auth);
            }
            user = (User)auth.getPrincipal();
        }
        return user.toDto(true);
    }

    @Operation(summary="Create a new user or bind to an existing user")
    @PostMapping(value={"/oauth/register"})
    @PermitAll
    public UserDto createOrBindFromOauth(@RequestBody UserDto userDto, @RequestParam(value="rememberMe") boolean rememberMe, HttpServletRequest request, HttpServletResponse response) {
        User createdUser;
        User user = userDto.toEntity();
        user.setLastLoginIp(IpUtil.getIpAddr((HttpServletRequest)request));
        if (StringUtils.hasText((String)userDto.getAvatarUrl())) {
            File avatarFile = new File();
            avatarFile.setFullPath(userDto.getAvatarUrl());
            user.setAvatar(avatarFile);
        }
        if ((createdUser = this.userService.createOrBindFromOauth(user)).getId() != null) {
            Authentication auth = this.authenticateUser(user, request, response);
            if (rememberMe) {
                this.rememberMeServices.loginSuccess(request, response, auth);
            }
        }
        return createdUser.toDto(true);
    }

    private Authentication authenticateUser(User user, HttpServletRequest request, HttpServletResponse response) {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication((Authentication)auth);
        SecurityContextHolder.setContext((SecurityContext)context);
        new HttpSessionSecurityContextRepository().saveContext(context, request, response);
        log.debug("User logged in: {}", auth.getPrincipal());
        return auth;
    }
}

