/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.user.model;

import com.shimi.gogoscrum.common.model.BaseEntity;
import com.shimi.gogoscrum.file.dto.FileDto;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.user.dto.UserDto;
import com.shimi.gogoscrum.user.model.Preference;
import com.shimi.gogoscrum.user.model.UserBinding;
import com.shimi.gogoscrum.user.utils.UserPreferenceConverter;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.CollectionUtils;

@Entity
public class User
extends BaseEntity
implements com.shimi.gsf.core.model.User {
    private static final long serialVersionUID = -2322205969864150058L;
    public static final String ROLE_USER = "ROLE_USER";
    private String username;
    private String nickname;
    private String password;
    private String phone;
    private String email;
    @OneToOne
    @JoinColumn(name="avatar_file_id")
    private File avatar;
    private boolean enabled = true;
    private Date lastLoginTime;
    private String lastLoginIp;
    @Convert(converter=UserPreferenceConverter.class)
    private Preference preference;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    private List<UserBinding> bindings = new ArrayList();
    @Transient
    private boolean bindToExistingUser;

    public User() {
    }

    public User(Long id) {
        this.id = id;
    }

    public UserDto toDto() {
        return this.toDto(false);
    }

    public UserDto toDto(boolean detailed) {
        UserDto dto = new UserDto();
        BeanUtils.copyProperties((Object)this, (Object)dto, (String[])new String[]{"password", "password", "bindings"});
        if (this.avatar != null) {
            FileDto avatarDto = new FileDto();
            avatarDto.setUrl(this.avatar.getUrl());
            dto.setAvatar(avatarDto);
        }
        if (detailed && !CollectionUtils.isEmpty((Collection)this.bindings)) {
            dto.setBindings(this.bindings.stream().map(UserBinding::toDto).toList());
        }
        return dto;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority(ROLE_USER));
        return authorities;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAvatarUrl() {
        return this.avatar != null ? this.avatar.getUrl() : null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    public Preference getPreference() {
        return this.preference;
    }

    public void setPreference(Preference preference) {
        this.preference = preference;
    }

    public File getAvatar() {
        return this.avatar;
    }

    public void setAvatar(File avatar) {
        this.avatar = avatar;
    }

    public List<UserBinding> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<UserBinding> bindings) {
        this.bindings = bindings;
    }

    public boolean isBindToExistingUser() {
        return this.bindToExistingUser;
    }

    public void setBindToExistingUser(boolean bindToExistingUser) {
        this.bindToExistingUser = bindToExistingUser;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public String toString() {
        return "User{id=" + this.id + ", username='" + this.username + "', nickname='" + this.nickname + "'}";
    }
}

