/*
 * Decompiled with CFR 0.152.
 */
package com.shimi.gogoscrum.user.service;

import com.shimi.gogoscrum.common.service.BaseServiceImpl;
import com.shimi.gogoscrum.common.util.RandomToolkit;
import com.shimi.gogoscrum.file.model.File;
import com.shimi.gogoscrum.file.model.FileType;
import com.shimi.gogoscrum.file.model.TargetType;
import com.shimi.gogoscrum.file.service.FileService;
import com.shimi.gogoscrum.user.model.Preference;
import com.shimi.gogoscrum.user.model.UserBinding;
import com.shimi.gogoscrum.user.model.UserFilter;
import com.shimi.gogoscrum.user.oauth.OauthProvider;
import com.shimi.gogoscrum.user.repository.UserBindingRepository;
import com.shimi.gogoscrum.user.repository.UserRepository;
import com.shimi.gogoscrum.user.repository.UserSpecs;
import com.shimi.gogoscrum.user.service.UserService;
import com.shimi.gsf.core.exception.BadRequestException;
import com.shimi.gsf.core.exception.BaseServiceException;
import com.shimi.gsf.core.exception.EntityDuplicatedException;
import com.shimi.gsf.core.exception.EntityNotFoundException;
import com.shimi.gsf.core.exception.NoPermissionException;
import com.shimi.gsf.core.model.Entity;
import com.shimi.gsf.core.model.EntityQueryResult;
import com.shimi.gsf.core.model.User;
import com.shimi.gsf.util.PageQueryResultConverter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCrypt;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class UserServiceImpl
extends BaseServiceImpl<com.shimi.gogoscrum.user.model.User, UserFilter>
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserRepository repository;
    @Autowired
    private FileService fileService;
    @Autowired
    private UserBindingRepository bindRepository;
    @Autowired
    private PluginManager pluginManager;
    private final Map<String, OauthProvider> oauthProvidersMap = new HashMap();

    @PostConstruct
    private void initPlugins() {
        List oauthProviderPlugins = this.pluginManager.getExtensions(OauthProvider.class);
        if (!oauthProviderPlugins.isEmpty()) {
            this.oauthProvidersMap.putAll(oauthProviderPlugins.stream().collect(Collectors.toMap(OauthProvider::getName, p -> p, (p1, p2) -> p1)));
            log.info("Loaded {} 3rd-party OAuth provider plugins: {}", (Object)oauthProviderPlugins.size(), (Object)String.join((CharSequence)", ", this.oauthProvidersMap.keySet()));
        } else {
            log.debug("No 3rd-party OAuth provider plugins found");
        }
    }

    protected UserRepository getRepository() {
        return this.repository;
    }

    protected void beforeCreate(com.shimi.gogoscrum.user.model.User user) {
        if (CollectionUtils.isEmpty((Collection)user.getBindings())) {
            this.verifyUsername(user);
            this.verifyPassword(user.getPassword());
            user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)user.getPassword()));
        } else {
            user.setUsername(RandomToolkit.getRandomString((int)16));
            user.setPassword(null);
        }
    }

    private void verifyUsername(com.shimi.gogoscrum.user.model.User user) {
        com.shimi.gogoscrum.user.model.User userById;
        if (!StringUtils.hasText((String)user.getUsername())) {
            throw new BaseServiceException("usernameRequired", "Username is required", HttpStatus.BAD_REQUEST);
        }
        com.shimi.gogoscrum.user.model.User userByUsername = this.repository.findByUsername(user.getUsername());
        if (userByUsername != null && !userByUsername.getId().equals(user.getId())) {
            throw new EntityDuplicatedException("duplicatedUsername", "Username already exists: " + userByUsername.getUsername());
        }
        if (user.getId() != null && (userById = (com.shimi.gogoscrum.user.model.User)super.get(user.getId())) != null && !userById.getUsername().equals(user.getUsername())) {
            throw new BaseServiceException("usernameCannotChange", "Username cannot be changed to: " + user.getUsername(), HttpStatus.BAD_REQUEST);
        }
        if (!StringUtils.hasText((String)user.getNickname())) {
            user.setNickname(user.getUsername());
        }
    }

    private void verifyPassword(String pwd) {
        if (!StringUtils.hasText((String)pwd)) {
            throw new BaseServiceException("passwordRequired", "Password is required", HttpStatus.BAD_REQUEST);
        }
        if (pwd.length() < 6) {
            throw new BaseServiceException("passwordTooShort", "Password must be at least 6 characters long", HttpStatus.BAD_REQUEST);
        }
    }

    public com.shimi.gogoscrum.user.model.User updateUserBasics(Long id, com.shimi.gogoscrum.user.model.User user) {
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        if (!id.equals(currentUser.getId())) {
            throw new NoPermissionException("User can only update their own information");
        }
        com.shimi.gogoscrum.user.model.User existingUser = (com.shimi.gogoscrum.user.model.User)this.get(id);
        existingUser.setNickname(user.getNickname());
        com.shimi.gogoscrum.user.model.User updatedUser = (com.shimi.gogoscrum.user.model.User)this.repository.save((Object)existingUser);
        log.info("User basic info updated: {}", (Object)updatedUser);
        return updatedUser;
    }

    public com.shimi.gogoscrum.user.model.User updateAvatar(Long userId, File avatarFile) {
        if (!Objects.equals(userId, this.getCurrentUser().getId())) {
            throw new NoPermissionException("You can only update your own avatar");
        }
        com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)this.get(userId);
        Long oldFileId = null;
        if (user.getAvatar() != null) {
            oldFileId = user.getAvatar().getId();
        }
        user.setAvatar((File)this.fileService.create((Entity)avatarFile));
        user.setUpdateTraceInfo((User)this.getCurrentUser());
        com.shimi.gogoscrum.user.model.User updatedUser = (com.shimi.gogoscrum.user.model.User)this.repository.save((Object)user);
        if (oldFileId != null) {
            this.fileService.delete(oldFileId);
        }
        log.info("User {} avatar updated", (Object)userId);
        return updatedUser;
    }

    public void deleteAvatar(Long userId) {
        if (!Objects.equals(userId, this.getCurrentUser().getId())) {
            throw new NoPermissionException("You can only delete your own avatar");
        }
        com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)this.get(userId);
        if (user.getAvatar() != null) {
            Long fileId = user.getAvatar().getId();
            user.setAvatar(null);
            user.setUpdateTraceInfo((User)this.getCurrentUser());
            this.repository.save((Object)user);
            this.fileService.delete(fileId);
            log.info("User {} avatar deleted", (Object)userId);
        } else {
            log.warn("User {} has no avatar to delete", (Object)userId);
        }
    }

    public com.shimi.gogoscrum.user.model.User update(Long id, com.shimi.gogoscrum.user.model.User user) {
        throw new BaseServiceException("notAllowed", "User update method is not allowed. Use updateUserBasics instead.", HttpStatus.BAD_REQUEST);
    }

    public boolean checkPassword(Long id, String oldPassword) {
        com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)this.get(id);
        return BCrypt.checkpw((String)oldPassword, (String)user.getPassword());
    }

    public void updatePassword(Long userId, String oldPassword, String newPassword) {
        this.verifyPassword(newPassword);
        if (!userId.equals(this.getCurrentUser().getId())) {
            throw new NoPermissionException("User can only update their own password");
        }
        com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)this.get(userId);
        if (!BCrypt.checkpw((String)oldPassword, (String)user.getPassword())) {
            throw new BaseServiceException("wrongPassword", "Incorrect old password", HttpStatus.PRECONDITION_FAILED);
        }
        String encodePassword = new BCryptPasswordEncoder().encode((CharSequence)newPassword);
        user.setPassword(encodePassword);
        this.repository.save((Object)user);
        log.info("Password updated for user {}", (Object)userId);
    }

    public com.shimi.gogoscrum.user.model.User updatePreference(Long userId, Preference preference) {
        com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)this.get(userId);
        user.setPreference(preference);
        user.setUpdateTraceInfo((User)this.getCurrentUser());
        com.shimi.gogoscrum.user.model.User savedUser = (com.shimi.gogoscrum.user.model.User)this.repository.save((Object)user);
        log.info("Preference updated for user {}: {}", (Object)userId, (Object)preference);
        return savedUser;
    }

    @EventListener(value={InteractiveAuthenticationSuccessEvent.class})
    public void userLoggedIn(InteractiveAuthenticationSuccessEvent event) {
        com.shimi.gogoscrum.user.model.User user = (com.shimi.gogoscrum.user.model.User)event.getAuthentication().getPrincipal();
        if (log.isDebugEnabled()) {
            log.debug("User logged in via {}: {}", (Object)event.getGeneratedBy().getSimpleName(), (Object)user);
        }
        this.updateLastLoginInfo(user);
    }

    public void updateLastLoginInfo(com.shimi.gogoscrum.user.model.User user) {
        com.shimi.gogoscrum.user.model.User existingUser = (com.shimi.gogoscrum.user.model.User)this.get(user.getId());
        existingUser.setLastLoginIp(user.getLastLoginIp());
        existingUser.setLastLoginTime(new Date());
        com.shimi.gogoscrum.user.model.User updatedUser = (com.shimi.gogoscrum.user.model.User)this.repository.save((Object)existingUser);
        if (log.isDebugEnabled()) {
            log.debug("Updated user's last login info: {}", (Object)updatedUser);
        }
    }

    public UserDetails loadUserByUsername(String username) {
        com.shimi.gogoscrum.user.model.User user = this.repository.findByUsername(username);
        if (user == null) {
            throw new EntityNotFoundException("Cannot find user by username \"" + username + "\"");
        }
        if (!StringUtils.hasText((String)user.getPassword())) {
            throw new BaseServiceException("pwdNotSet", "User has no password set. Please use social login.", HttpStatus.PRECONDITION_FAILED);
        }
        log.debug("Loaded user by username {}: {}", (Object)username, (Object)user);
        return user;
    }

    public EntityQueryResult<com.shimi.gogoscrum.user.model.User> findProjectMates(int page, int pageSize, String keyword) {
        com.shimi.gogoscrum.user.model.User byUsername;
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
        com.shimi.gogoscrum.user.model.User currentUser = this.getCurrentUser();
        Object contents = StringUtils.hasText((String)keyword) ? ((byUsername = this.repository.findByUsername(keyword)) != null ? new PageImpl(List.of(byUsername)) : this.repository.findProjectMates(currentUser, (Pageable)pageable, keyword)) : this.repository.findProjectMates(currentUser, (Pageable)pageable);
        return PageQueryResultConverter.toQueryResult((Page)contents);
    }

    public List<OauthProvider.ProviderConfig> getOauthProviders() {
        return this.oauthProvidersMap.values().stream().map(OauthProvider::getConfig).toList();
    }

    public OauthProvider getOauthProvider(String name) {
        if (!this.oauthProvidersMap.containsKey(name)) {
            throw new BadRequestException("Unsupported OAuth provider: " + name);
        }
        return (OauthProvider)this.oauthProvidersMap.get(name);
    }

    public com.shimi.gogoscrum.user.model.User retrieveUser(OauthProvider.OauthInfo oauthInfo) {
        OauthProvider oauthProvider = (OauthProvider)this.oauthProvidersMap.get(oauthInfo.getProvider());
        if (oauthProvider == null) {
            throw new BadRequestException("Unsupported OAuth provider: " + oauthInfo.getProvider());
        }
        OauthProvider.OauthUser oauthUser = oauthProvider.retrieveUser(oauthInfo);
        return this.parseUser(oauthUser);
    }

    private com.shimi.gogoscrum.user.model.User parseUser(OauthProvider.OauthUser oauthUser) {
        UserBinding binding = this.bindRepository.getByProviderAndExtUserId(oauthUser.getProvider(), oauthUser.getExtUserId());
        com.shimi.gogoscrum.user.model.User user = null;
        if (binding != null) {
            if (StringUtils.hasText((String)oauthUser.getUnionId()) && !StringUtils.hasText((String)binding.getUnionId())) {
                binding.setUnionId(oauthUser.getUnionId());
                this.bindRepository.save((Object)binding);
                log.info("Updated union ID for existing binding: {}", (Object)binding);
            }
            user = (com.shimi.gogoscrum.user.model.User)this.get(binding.getUser().getId());
        } else if (StringUtils.hasText((String)oauthUser.getUnionId()) && (binding = this.bindRepository.getTopByUnionId(oauthUser.getUnionId())) != null) {
            UserBinding newBinding = new UserBinding();
            newBinding.setProvider(oauthUser.getProvider());
            newBinding.setExtUserId(oauthUser.getExtUserId());
            newBinding.setUnionId(oauthUser.getUnionId());
            newBinding.setUser(binding.getUser());
            newBinding.setAllTraceInfo((User)binding.getUser());
            this.bindRepository.save((Object)newBinding);
            log.info("Created new binding for existing user by union ID: {}", (Object)newBinding);
            user = (com.shimi.gogoscrum.user.model.User)this.get(binding.getUser().getId());
        }
        if (user != null) {
            if (!user.isEnabled()) {
                throw new NoPermissionException("userDisabled", "User is disabled");
            }
            return user;
        }
        user = new com.shimi.gogoscrum.user.model.User();
        user.setNickname(oauthUser.getUsername());
        File avatarFile = new File();
        avatarFile.setFullPath(oauthUser.getAvatarUrl());
        user.setAvatar(avatarFile);
        UserBinding newBinding = new UserBinding();
        newBinding.setProvider(oauthUser.getProvider());
        newBinding.setExtUserId(oauthUser.getExtUserId());
        newBinding.setUnionId(oauthUser.getUnionId());
        newBinding.setUser(user);
        user.getBindings().add(newBinding);
        return user;
    }

    public com.shimi.gogoscrum.user.model.User createOrBindFromOauth(com.shimi.gogoscrum.user.model.User user) {
        UserBinding binding = (UserBinding)user.getBindings().getFirst();
        this.verifyBinding(binding);
        com.shimi.gogoscrum.user.model.User targetUser = null;
        if (user.isBindToExistingUser()) {
            targetUser = this.repository.findByUsername(user.getUsername());
            if (targetUser == null) {
                throw new EntityNotFoundException("userNotFound", "Cannot find user by username: " + user.getUsername());
            }
            if (!StringUtils.hasText((String)targetUser.getPassword())) {
                throw new BaseServiceException("wrongPassword", "The target user has no password set. Cannot bind to OAuth account.", HttpStatus.PRECONDITION_FAILED);
            }
            if (!targetUser.isEnabled()) {
                throw new NoPermissionException("userDisabled", "The target user is disabled. Cannot bind to OAuth account.");
            }
            if (!BCrypt.checkpw((String)user.getPassword(), (String)targetUser.getPassword())) {
                throw new BaseServiceException("wrongPassword", "Wrong password", HttpStatus.PRECONDITION_FAILED);
            }
        } else {
            targetUser = (com.shimi.gogoscrum.user.model.User)this.create((Entity)user);
            log.info("Created new user from {} OAuth: {}", (Object)binding.getProvider(), (Object)targetUser);
            if (user.getAvatar() != null && StringUtils.hasText((String)user.getAvatar().getFullPath())) {
                File avatarFile = new File();
                avatarFile.setFullPath(user.getAvatar().getFullPath());
                avatarFile.setStorageProvider("EXTERNAL");
                avatarFile.setTargetType(TargetType.USER_AVATAR);
                avatarFile.setType(FileType.IMAGE);
                avatarFile.setName("avatar_" + binding.getProvider() + "_" + binding.getExtUserId());
                avatarFile.setAllTraceInfo((User)targetUser);
                targetUser.setAvatar((File)this.fileService.create((Entity)avatarFile));
                this.repository.save((Object)targetUser);
                log.info("Created avatar file for new OAuth user {}: {}", (Object)targetUser.getId(), (Object)targetUser.getAvatar());
            }
        }
        binding.setId(null);
        binding.setUser(targetUser);
        binding.setAllTraceInfo((User)targetUser);
        this.bindRepository.save((Object)binding);
        log.info("Created new OAuth binding from {} to user: {}", (Object)binding.getProvider(), (Object)targetUser);
        return targetUser;
    }

    private void verifyBinding(UserBinding binding) {
        if (!StringUtils.hasText((String)binding.getProvider())) {
            throw new BadRequestException("Bad binding info, OAuth provider is missing");
        }
        if (!StringUtils.hasText((String)binding.getExtUserId())) {
            throw new BadRequestException("Bad binding info, external user ID is missing");
        }
        if (!this.oauthProvidersMap.containsKey(binding.getProvider())) {
            throw new BadRequestException("Bad binding info, unsupported OAuth provider: " + binding.getProvider());
        }
        UserBinding existingBind = this.bindRepository.getByProviderAndExtUserId(binding.getProvider(), binding.getExtUserId());
        if (existingBind != null) {
            throw new EntityDuplicatedException("This " + binding.getProvider() + " account is already linked to another user");
        }
    }

    protected Specification<com.shimi.gogoscrum.user.model.User> toSpec(UserFilter filter) {
        Specification querySpec = null;
        if (StringUtils.hasText((String)filter.getKeyword())) {
            String keyword = filter.getKeyword();
            Specification nameLike = UserSpecs.nicknameLike((String)keyword).or(UserSpecs.usernameLike((String)keyword));
            try {
                Long id = Long.parseLong(filter.getKeyword());
                querySpec = nameLike.or(UserSpecs.idEquals((Long)id));
            }
            catch (NumberFormatException e) {
                querySpec = nameLike;
            }
        }
        if (filter.getEnabled() != null) {
            Specification isEnabled = UserSpecs.enabledEquals((Boolean)filter.getEnabled());
            querySpec = querySpec == null ? isEnabled : querySpec.and(isEnabled);
        }
        return querySpec;
    }
}

